/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import oracle.cluster.verification.OracleFileType;
import oracle.cluster.verification.database.DatabaseConnectInfo;
import oracle.jdbc.driver.OracleConnection;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.task.DatabaseTask;
import oracle.ops.verification.framework.engine.task.DatabaseTaskException;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.TypeFinder;
import oracle.ops.verification.framework.storage.VerifyStorage;
import oracle.ops.verification.util.MultiNodeException;

public class TaskAuditFileDestCheck
extends DatabaseTask {
    private static final String m_query = "select i.instance_name, i.host_name, p.value audit_file_dest from GV$INSTANCE i, GV$PARAMETER p where i.inst_id = p.inst_id and name = 'audit_file_dest'";
    VerifyStorage m_vfyStorage = new VerifyStorage();

    public TaskAuditFileDestCheck(Version crsVer, Collection<DatabaseConnectInfo> dbConInfo) {
        super(crsVer, dbConInfo);
    }

    @Override
    public boolean performTask() {
        boolean retVal = true;
        Trace.out((String)"Performing shared AUDIT_FILE_DEST location check...");
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("11122", false));
        for (String database : this.databases()) {
            String errMsg;
            ArrayList<String> instList = new ArrayList<String>();
            ArrayList<String> nodeList = new ArrayList<String>();
            ArrayList<String> pathList = new ArrayList<String>();
            try {
                OracleConnection conn = this.getConnection(database);
                Statement stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery(m_query);
                while (rs.next()) {
                    instList.add(rs.getString(1));
                    nodeList.add(rs.getString(2));
                    pathList.add(rs.getString(3));
                }
                rs.close();
                stmt.close();
                if (this.verifyAuditFileDest(database, instList, nodeList, pathList)) continue;
                retVal = false;
            }
            catch (DatabaseTaskException exDT) {
                Trace.out((String)("SQLException while verifying AUDIT_FILE_DEST for daatabase " + database + ". message :" + exDT.getMessage()));
                errMsg = s_gMsgBundle.getMessage("11125", true);
                errMsg = errMsg + LSEP + exDT.getMessage();
                this.m_resultSet.addErrorDescription(database, new ErrorDescription(errMsg));
                this.m_resultSet.addResult(database, 2);
                retVal = false;
            }
            catch (SQLException exSql) {
                Trace.out((String)("SQLException while verifying AUDIT_FILE_DEST for daatabase " + database + ". message :" + exSql.getMessage()));
                errMsg = s_gMsgBundle.getMessage("11125", true);
                errMsg = errMsg + LSEP + exSql.getMessage();
                this.m_resultSet.addErrorDescription(database, new ErrorDescription(errMsg));
                this.m_resultSet.addResult(database, 2);
                retVal = false;
            }
        }
        if (retVal) {
            Trace.out((String)"Check for shared AUDIT_FILE_DEST location passed.");
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("11124", false));
            this.m_resultSet.addResult(this.databases(), 1);
        }
        return retVal;
    }

    private boolean verifyAuditFileDest(String dbName, List<String> instList, List<String> nodeList, List<String> pathList) {
        boolean retVal = true;
        if (instList.size() < 2) {
            return retVal;
        }
        TypeFinder stFinder = new TypeFinder();
        ArrayList<StorageInfo> stInfos = new ArrayList<StorageInfo>();
        try {
            int i;
            for (i = 0; i < instList.size(); ++i) {
                String inst = instList.get(i);
                String node = nodeList.get(i);
                String path = pathList.get(i);
                Trace.out((String)("getting storage info. inst=" + inst + ",auditFileDest=" + path + ",node=" + node));
                StorageInfo stInfo = stFinder.getStorageInstance(path, node);
                stInfos.add(stInfo);
            }
            Vector<StorageInfo> tmpStInfos = new Vector<StorageInfo>();
            for (i = 0; i < stInfos.size(); ++i) {
                StorageInfo stInfo1 = (StorageInfo)stInfos.get(i);
                Trace.out((String)("inst=" + instList.get(i) + ". path=" + stInfo1.getPath()));
                Trace.out((String)("file System:" + stInfo1.getTypeStr()));
                if (stInfo1.getType() != 14) continue;
                boolean bBadInst = false;
                String auditFileDest = pathList.get(i);
                String badInsts = instList.get(i);
                for (int j = i + 1; j < stInfos.size(); ++j) {
                    StorageInfo stInfo2 = (StorageInfo)stInfos.get(j);
                    if (stInfo2.getType() != 14) continue;
                    tmpStInfos.clear();
                    tmpStInfos.add(stInfo1);
                    tmpStInfos.add(stInfo2);
                    Trace.out((String)("calling isShared on m_vfyStorage. inst1=" + instList.get(i) + ",inst2=" + instList.get(j)));
                    if (!this.m_vfyStorage.isShared(tmpStInfos, OracleFileType.RAC_SOFTWARE)) continue;
                    badInsts = ',' + instList.get(j);
                    Trace.out((String)(auditFileDest + " is shared between instances " + badInsts));
                    bBadInst = true;
                }
                if (!bBadInst) continue;
                String errMsg = s_gMsgBundle.getMessage("11123", true, (Object[])new String[]{auditFileDest, badInsts, dbName});
                this.m_resultSet.addErrorDescription(dbName, new ErrorDescription(errMsg));
                this.m_resultSet.addResult(dbName, 3);
                ReportUtil.sureprintln(errMsg);
                retVal = false;
            }
        }
        catch (StorageException exS) {
            Trace.out((String)("StorageException occured. message: " + exS.getMessage()));
            String errMsg = s_gMsgBundle.getMessage("11125", true);
            errMsg = errMsg + LSEP + exS.getMessage();
            this.m_resultSet.addErrorDescription(dbName, new ErrorDescription(errMsg));
            this.m_resultSet.addResult(dbName, 2);
            retVal = false;
        }
        catch (MultiNodeException exM) {
            Trace.out((String)("MultiNodeException occured. message: " + exM.getMessage()));
            String errMsg = s_gMsgBundle.getMessage("11125", true);
            errMsg = errMsg + LSEP + exM.getMessage();
            this.m_resultSet.addErrorDescription(dbName, new ErrorDescription(errMsg));
            this.m_resultSet.addResult(dbName, 2);
            retVal = false;
        }
        return retVal;
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("11121", false);
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("11120", false);
    }
}

